/*Header File for Watcom C/C++ User Defined Library File Utility Functions*/

/*This file includes 1.) Prototypes for user file utility functions; 2.) #DEFINE directives for any symbolic constants */
/*     and macros used in the modules for the user file utility functions; and 3.) Definitions of any structures or external variables used in these modules*/



/*Begin statements to avoid multiple inclusions of this header file into compiled source code*/
#if !defined( _FILESVC_H_INCLUDED )
#define _FILESVC_H_INCLUDED
#endif
/*End statements to avoid multiple inclusions of this header file into compiled source code*/



/*Begin head file items for the FileRead utility function*/
#define MAXLINES 10000
typedef struct {
	int FileOpenRC;	/*File read return code; 0 = cannot open the file; 1 = successfully opened and read the file in ASCII, or text, mode; 2 = successfully opened and read the file in binary mode; 10 = */
	/*10 = not enough memory to allocate the buffer; 101 = cannot read the ASCII file; 102 = cannot read the binary file*/
	int NumberOfLinesRead;	/*Total number of lines read from the file*/
	unsigned char *Line[MAXLINES];	/* *Line[] is the "pointer to the multidimensional array that holds the lines read from the file*/
} FREAD;
FREAD *FileRead(char *FileName);	/*Prototype for the FileRead utility function*/
/*End head file items for the FileRead utility function*/
