/*Begin include statements*/
#include "filesvc.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/*End include statements*/



/*Begin declaration of all external variables, ones that remain available, static, after the FileRead function has finished*/
/*End declaration of all external variables, ones that remain available, static, after the FileRead function has finished*/



/*Begin the FileRead function header*/
FREAD *FileRead(char *FileName)
/*End the FileRead function header*/
{
	/*Begin declaration of variables local to the FileRead function*/
	FREAD ReturnResult; /*This variable should be declared before the FileRead function. Declares one instance, named ReturnResult, of the defined structure, FREAD*/
	FILE *fp;
	char *Mode1 = "rt", *Mode2 = "rb";
	long SavePosition, FileSize, RemainingFileSize, Offset;
	char *Buffer;	/*Uninitialized pointer to a temporary memory storage area for each "line" read from the ASCII or binary file*/
	int TrialNumberOfBytesToRead, ActualBytesRead, SizeInBytes, Index = 0;
	/*End declaration of variables local to the FileRead function*/

	

	/*Begin initializing the members of the ReturnResult instance of the FREAD structure*/
	ReturnResult.FileOpenRC = 0;
	ReturnResult.NumberOfLinesRead = 0;
	for(Index = 0; Index < MAXLINES;Index++)
		ReturnResult.Line[Index] = "I";
	/*End initializing the members of the ReturnResult instance of the FREAD structure*/



	/*Begin opening the file for reading*/
	if((fp = fopen(FileName, Mode1)) != NULL)
		ReturnResult.FileOpenRC = 1;
	else
	/*The binary file read part does not yet work. The fopen function successfully opens any file, including*/
	/*a binary one, in text (ASCII read). However, if it is a binary file, I get a memory (general protection*/
	/*fault error, somewhere in the file reading process. I need an error event handler, or some way to*/
	/*determine binary versus ASCII before attempting to read the file in text mode*/
		{
			if((fp = fopen(FileName, Mode2)) != NULL)
			ReturnResult.FileOpenRC = 2;
		}
	/*End opening the file for reading*/



	/*Begin finding the length, in bytes, of the openned ASCII or binary file*/
	if(ReturnResult.FileOpenRC != 0)
	{
		SavePosition = ftell(fp);
		fseek(fp, 0L, SEEK_END);
  		FileSize = ftell(fp);
		fseek(fp, SavePosition, SEEK_SET);
	}
	/*End finding the length, in bytes, of the openned ASCII or binary file*/



	/*Begin setting aside memory for the pointer, Buffer, and then initializing it*/
	Buffer = (char*)malloc(1000);
	if (Buffer != NULL)
		Buffer = "Harry's folly!";
	else
	{
		ReturnResult.FileOpenRC = 10;	/*Not enough memory to allocate the buffer*/
		exit(1);
	}



	/*Begin reading the opened ASCII file (ReturnResult.FileOpenRC = 1)*/
	if(ReturnResult.FileOpenRC == 1)
	{
		RemainingFileSize = FileSize - ftell(fp);
		for (Index = 0; RemainingFileSize > 0;Index++)
		{
			TrialNumberOfBytesToRead = min(RemainingFileSize, 1000);	/*Assumes that in every ASCII file the line length is <= 1000 bytes*/
			if(fgets(Buffer, TrialNumberOfBytesToRead, fp) != NULL)
			{
				ActualBytesRead = ftell(fp) + RemainingFileSize - FileSize;
				if(ActualBytesRead > 0)
				{
					ReturnResult.Line[Index] = (char*)malloc(ActualBytesRead + 1);
					strcpy(ReturnResult.Line[Index], Buffer);
					RemainingFileSize = FileSize - ftell(fp);
				}
				else	/*The remaining part of the file is not being read. Therefore, index back one and exit the FileRead function*/
				{
					Index--;
					break;
				}
			}
			else
			{
				if((ftell(fp) + RemainingFileSize - FileSize) > 1)	/*Perhaps the end of file (EOL) character was read on the last line, thereby giving a NULL result*/
				{
					Offset = FileSize - RemainingFileSize - ftell(fp);
					fseek(fp, Offset, SEEK_CUR);
					TrialNumberOfBytesToRead = -1*Offset - 1;
					if(fgets(Buffer, TrialNumberOfBytesToRead, fp) != NULL)
					{
						ReturnResult.Line[Index] = (char*)malloc(ActualBytesRead + 1);
						strcpy(ReturnResult.Line[Index], Buffer);
						RemainingFileSize = FileSize - ftell(fp);
					}
					else
					{
						Index--;
						break;
					}
				}
				else	/*EOL character, only, occupies the last line*/
				{
					Index--;
					break;
				}
			}
		}
		if(Index < 0)	/*Unable to read the ASCII file*/
		{
			ReturnResult.FileOpenRC = 101;
		}
		ReturnResult.NumberOfLinesRead = Index + 1;
	}
	/*End reading the opened ASCII file (ReturnResult.FileOpenRC = 1)*/



	/*Begin reading the opened binary file (ReturnResult.FileOpenRC = 2)*/
	if(ReturnResult.FileOpenRC == 2)
	{
		SizeInBytes = sizeof(unsigned char);
		RemainingFileSize = FileSize - ftell(fp);
		for (Index = 0; RemainingFileSize > 0;Index++)
		{
			TrialNumberOfBytesToRead = min(RemainingFileSize, 60);	/*Restricts maximum "line length" for binary files to be <= 60 bytes*/
			if(fread(Buffer, SizeInBytes, TrialNumberOfBytesToRead, fp) == TrialNumberOfBytesToRead)
			{
				ReturnResult.Line[Index] = (char*)malloc(ActualBytesRead + 1);
				strcpy(ReturnResult.Line[Index], Buffer);
				RemainingFileSize = FileSize - ftell(fp);
			}
			else
			{
				if(Index==0)	/*Unable to read the binary file*/
				ReturnResult.FileOpenRC = 102;
			}
		}
		ReturnResult.NumberOfLinesRead = Index + 1;
	}
	/*End reading the opened binary file (ReturnResult.FileOpenRC = 2)*/
fclose(fp);
return (&ReturnResult);	/*The FileRead function returns a pointer to "ReturnResult", a declared instance of the FREAD structure*/
}
