/* ZTBInstl.Cmd: Install ZTBold

    Copyright (c) 2001 Steven Levine and Associates, Inc.
    All rights reserved.

    $TLIB$: $ &(#) %n - Ver %v, %f $
    TLIB: $ $

    Revisions	15 Oct 01 SHL - Release

*/

signal on ERROR
signal on FAILURE name Error
signal on HALT
signal on NOTREADY name Error
signal on NOVALUE name Error
signal on SYNTAX name Error

call Initialize

Main:

  parse arg szRest
  szRest = strip(szRest)

  do while szRest \= ''
    parse var szRest szArg szRest
    szRest = strip(szRest)
    szArgU = translate(szArg)

    select
    when left(szArgU, 3) == '/B:' then do
      Gbl.szBootDrv = substr(szArg, 4)
      if right(Gbl.szBootDrv, 1) \= ':' then
        Gbl.szBootDrv = Gbl.szBootDrv':'
      if length(Gbl.szBootDrv) \= 2 then
        call Usage Gbl.szBootDrv 'unexpected'
    end
    when left(szArgU, 3) == '/L:' then
      Gbl.szLogFile = substr(szArg, 4)
    when left(szArgU, 3) == '/S:' then
      Gbl.szImgdir = substr(szArg, 4)
    when left(szArgU, 3) == '/T:' then
      Gbl.szTargetDir = substr(szArg, 4)
    otherwise
      call Usage szArg 'unexpected'
    end
  end /* while */

  if symbol('Gbl.szBootDrv') = 'LIT' then
    call Usage '/B: missing'

  if symbol('Gbl.szLogFile') = 'LIT' then
    call Usage '/L:  missing'

  if symbol('Gbl.szImgDir') = 'LIT' then
    call Usage '/S:  missing'

  if symbol('Gbl.szTargetDir') = 'LIT' then
    call Usage '/T:  missing'

  call MakeDir Gbl.szTargetDir

  call LogWrite Gbl.szTargetDir 'created'

  signal off error
  'copy' Gbl.szImgDir'\*' Gbl.szTargetDir
  signal on error
  if RC \= 0 then
    call Fatal 'Copy' Gbl.szImgDir'\*' Gbl.szTargetDir 'failed -' RC

  call LogWrite Gbl.szImgDir'\*' 'copied to' Gbl.szTargetDir

  /* Create ZtBold program object on Desktop */
  szSetup = 'EXENAME='Gbl.szBootDrv'\ztbold\ztb.exe;' ||,
            'PARAMETERS='Gbl.szBootDrv'\;' ||,
            'STARTUPDIR='Gbl.szBootDrv'\ztbold;' ||,
            'ICONFILE='Gbl.szBootDrv'\ztbold\ztb.ico;' ||,
            'PROGTYPE=VIO' ||,
            'OBJECTID=<ZtBold>;'

  call CreatePgmObject 'ZtBold', '<WP_DESKTOP>', szSetup

  call LogWrite 'ZTBold objects created'

  exit 0

/* end main */

/*=== CreatePgmObject(Name, Location, Setup) ===*/

CreatePgmObject: procedure expose Gbl.

  szName = arg(1)
  szLocation = arg(2)
  szSetup = arg(3)

  /* Create program object */
  say 'Creating' szName 'object...'
  rc = SysCreateObject('WPProgram',,
                       szName,,
                       szLocation,,
                       szSetup,,
                       'REPLACE')
  if rc \= 1 then
    call Fatal 'Can not create' szName 'object'

  return

/* end CreatePgmObject */

/*=== Usage(szMsg): Report usage error ===*/

Usage:

  parse arg szMsg
  say szMsg
  call LogWrite szMsg
  say 'Usage:' Gbl.szCmdName '/b:bootdrive /l:logfile /s:sourcedir /t:targetdir'
  call LogWrite 'Usage:' Gbl.szCmdName '/b:bootdrive /l:logfile /s:sourcedir /t:targetdir'

  exit x2d(1600)		/* Incorrect invocation */

/* end UsageHelp */

/*====================================================== */
/*=== Common Code - Delete unused, but do not modify === */
/*====================================================== */

/*=== Error: Trap ERROR, FAILURE etc. conditions ===*/

Error:

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source =' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Error */

/*=== Fatal: Report fatal error and exit ===*/

Fatal:

  parse arg szMsg

  say szMsg
  call LogWrite szMsg

  exit x2d(1604)		/* Unexpected condition */

/* end Fatal */

/*=== Halt: Trap HALT condition ===*/

Halt:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source = ' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Halt */

/*=== Initialize: Intialize globals ===*/

Initialize:

  /* Set Gbl.szCmdName */

  parse source . . Gbl.szCmdName
  Gbl.szCmdName = filespec('N', Gbl.szCmdName)
  c = pos('.', Gbl.szCmdName)
  if c > 1 then
    Gbl.szCmdName = substr(Gbl.szCmdName, 1, c - 1)

  call LoadFuncs

  return

/* end Initialize */

/*=== LoadFuncs: Load fuctions ===*/

LoadFuncs:

/* Add all Rexx functions */
if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  if RESULT then
    call Fatal 'Cannot load SysLoadFuncs'
  call SysLoadFuncs
end /* end do */

return

/* end LoadFuncs */

/*=== LogWrite(szLine): Write line to log ===*/

LogWrite: procedure expose Gbl.

  parse arg sz

  if symbol('Gbl.szLogFile') == 'LIT' then
    say date() time() Gbl.szCmdName':' sz
  else do
    call lineout Gbl.szLogFile, date() time()':' sz
    if RESULT \= 0 then
      exit x2d(1604)
  end

  return

/* end LogWrite */

/*=== MakeDir(szDirName): Make directory creating tree as needed ===*/

MakeDir: procedure expose Gbl.

  parse arg szTail
  szDir = ''

  do forever

    /* Build next */
    if szDir \= '' & right(szDir, 1) \= '\' then
      szDir = szDir'\'
    i = pos('\', szTail)
    if i = 0 then do
      szDir = szDir || szTail
      szTail = ''
    end
    else do
      szDir = szDir || substr(szTail, 1, i - 1)
      szTail = substr(szTail, i + 1)
    end

    if right(szDir, 2) = ':\' | right(szDir, 1) = ':' then do
      err = SysDriveInfo(left(szDir, 2))
      if err = '' then
        err = 3
      else
        err = 0
    end
    else do
      err = SysMkDir(szDir)
      if err = 5 then do
	call SysFileTree szDir, 'a', 'D'
        if rc = 0 then do
          if a.0 = 1 then
            err = 0                   /* Already exists */
        end
      end
    end
    if err \= 0 then
      call Fatal 'sysmkdir failed for' szDir '-' err
    if szTail == '' then
      leave
  end /* do */

  return err

/* end MakeDir */

/* The end */
