/* SavLANLK.CMD - Save locked files list
                  Args bootdrive (i.e. C:) and logfile
                  Returns 0 or error code

Check config.sys for ibmlanlk driver and if found remove the driver
and merge the list file with and previous saved list files.

*/

signal on HALT
signal on NOVALUE name Error
signal on SYNTAX name Error

Gbl.szCmdName = 'SavLANLk'

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

parse arg szBootDrv Gbl.szLogFile .

if szBootDrv = '' then
  drop szBootDrv                /* Force error */

if Gbl.szLogFile = '' then
  drop Gbl.szLogFile

szConfigSys = szBootDrv'\CONFIG.SYS'

szTmpLockList = szBootDrv'\OS2\INSTALL\CLTLANLK.LST'

/* retry in case config.sys locked by someone else */

do sleepcnt = 0 to 12
  rc = stream(szConfigSys, 'C', 'OPEN READ')
  if rc = 'READY:' then do
    call stream szConfigSys, 'C', 'CLOSE'
    leave
  end
  say ''
  call SysSleep 5
end

if rc \= 'READY:' then
  call Fatal 'Can not open' szConfigSys

fGotLockedFiles = 0
iLine = 0

do while lines(szConfigSys) > 0
  iLine = iLine + 1
  aszCfgSys.iLine = linein(szConfigSys)
  if fGotLockedFiles = 0 then do
    parse upper var aszCfgSys.iLine szOp szLockList
    fGotLockedFiles = pos('IBMLANLK',szOp)
    if fGotLockedFiles > 0 then
      parse upper var szOp 'DEVICE='szDriverPath'\IBMLANLK'.
  end
end

call lineout szConfigSys                /* Close */
aszCfgSys.0 = iLine

/* Remove ibmlanlk driver lines from config.sys */

if fGotLockedFiles = 0 then
  call LogWrite 'Warning: SavLANLK called with no files locked'
else do

  'attrib -r 'szConfigSys

  do sleepcnt = 1 to 30
    'erase' szConfigSys
    if rc = 0 then
      leave
    say ''
    call SysSleep 5
  end

  if rc \= 0 then
    call Fatal 'Can not erase' szConfigSys

  /* Rewrite config.sys dropping lines referencing IBMLANLK */

  do iLine = 1 to aszCfgSys.0
    szLine = translate(aszCfgSys.iLine)
    f = pos('IBMLANLK',szLine)
    If f = 0 then
      call lineout szConfigSys, aszCfgSys.iLine
  end
  call lineout szConfigSys              /* Close */

  /* Check if temp list file exists */
  call SysFileTree szTmpLockList, 'aszFiles', 'F'

  /* If not, write driver path as first line */
  if aszFiles.0 = 0 then
    call lineout szTmpLockList, szDriverPath

  /* copy/merge list file to temp list file */
  do while lines(szLockList) > 0
    szLine = linein(szLockList)
    call lineout szTmpLockList, szLine
  end

  call lineout szLockList               /* Close */
  call lineout szTmpLockList            /* Close */

  if 1 then 'epm' szLockList szTmpLockList

  '@erase' szLockList

  call LogWrite 'Saved locked files list' szLockList

end /* if fGotLockList */

return 0

/*====================================================== */
/*=== Common Code - Delete unused, but do not modify === */
/*====================================================== */

/*=== Error() - report ERROR, FAILURE etc. conditions ===*/

Error:
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source = ' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Error */

/*=== Fatal(message) Report fatal error and exit ===*/

Fatal:
  parse arg szMsg
  say szMsg
  call LogWrite szMsg
  exit x2d(1604)		/* Unexpected condition */

/* end Fatal */

/*=== Halt() - report HALT condition ===*/

Halt:
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source = ' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Halt */

/*=== LogWrite(szLine): Write line to log ===*/

LogWrite: procedure expose Gbl.

  parse arg sz

  sz = date() time() Gbl.szCmdName':' sz
  if symbol('Gbl.szLogFile') == 'LIT' then
    say sz
  else do
    call lineout Gbl.szLogFile, date() time()':' sz
    if RESULT \= 0 then do
      say sz
      say 'Can not write to' Gbl.szLogFile
      exit x2d(1604)
    end
  end

  return

/* end LogWrite */

/* The end */