/* RstLANLK.CMD - Restore locked file driver
                  Args is bootdrive
                  Returns 0 or error code

   Copy saved locked file list to default lock list
   Put driver back into the config.sys
*/

signal on HALT
signal on NOVALUE name Error
signal on SYNTAX name Error

Gbl.szCmdName = 'RstLANLk'

call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'
call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'

parse arg szBootDrv Gbl.szLogFile .

if szBootDrv = '' then
  drop szBootDrv                /* Force error */

if Gbl.szLogFile = '' then
  drop Gbl.szLogFile

szConfigSys = szBootDrv'\CONFIG.SYS'

szTmpLockList = szBootDrv'\OS2\INSTALL\CLTLANLK.LST'
szLockList = szBootDrv'\OS2\INSTALL\IBMLANLK.LST'

call SysFileTree szLockList, 'aszFiles', 'F'

if aszFiles.0 > 0 then
  call Fatal 'RstLANLK called while' szLockList 'exists'

/* retry in case config.sys locked by someone else */

do sleepcnt = 0 to 12
  rc = stream(szConfigSys, 'C', 'OPEN READ')
  if rc = 'READY:' then do
    call stream szConfigSys, 'C', 'CLOSE'
    leave
  end
  say ''
  call SysSleep 5
end

if rc \= 'READY:' then
  call Fatal 'Can not open' szConfigSys

/* Check temp lock list exists
   If so, copy and update config.sys
   If not, do nothing
*/

call SysFileTree szTmpLockList, 'aszFiles', 'F'

if aszFiles.0 = 0 then
  call LogWrite 'Warning: RstLANLK called for non-existant' szTmpLockList
else do

  /* Yes - get saved path to ibmlanlk.sys from line 1 */
  szDriverPath = translate(linein(szTmpLockList))

  /* Copy saved lock list back to default list */
  do while Lines(szTmpLockList) > 0
    szLine = linein(szTmpLockList)
    call lineout szLockList, szLine
  end

  call charout szLockList, x2c('1a')	/* Book says EOF needed */
  call lineout szLockList               /* Close */

  call lineout szTmpLockList            /* Close */

  'attrib -r 'szConfigSys
  'erase' szTmpLockList

  /* Read in config.sys and check for ifs=hpfs */

  iLine = 0
  fGotHPFSIFS = 0

  do while lines(szConfigSys) > 0
    iLine = iLine + 1
    aszCfgSys.iLine = linein(szConfigSys)
    if fGotHPFSIFS = 0 then do
      szLine = translate(aszCfgSys.iLine,, '09'x)       /* Tabs to blanks */
      szLine = translate(space(szLine, 0))      /* Uppercase, delete blanks */
      i = pos('IFS', szLine)
      i2 = pos('HPFS', szLine)
      fGotHPFSIFS = i = 1 & i2 > 1
    end
  end
  aszCfgSys.0 = iLine
  call lineout szConfigSys              /* Close */

  do sleepcnt = 0 to 30
    'erase' szConfigSys
    if rc = 0 then
      leave
    say ''
    call SysSleep 5
  end

  if rc \= 0 then
    call Fatal 'Can not erase' szConfigSys

  /* Put IBMLANLK driver lines back into config.sys */
  /* Put lines after hpfs line or at start */

  fChanged = 0
  do iLine = 1 to aszCfgSys.0
    call lineout szConfigSys, aszCfgSys.iLine
    if \ fChanged then do
      szLine = translate(aszCfgSys.iLine,, '09'x)       /* Tabs to blanks */
      szLine = translate(space(szLine, 0))      /* Uppercase, delete blanks */
      i = pos('IFS', szLine)
      i2 = pos('HPFS', szLine)
      If (i = 1 & i2 > 1) | fGotHPFSIFS = 0 then do
        call lineout szConfigSys, 'DEVICE='|| szDriverPath || '\IBMLANLK.SYS '|| szLockList
        call lineout szConfigSys, 'RUN='|| szDriverPath || '\IBMLANLK.EXE '|| szLockList
        fChanged = 1
      end
    end
  end
  call lineout szConfigSys              /* Close */

  say 'Restored locked files list' szLockList

  if 1 then 'epm' szLockList

end /* if temp list exists */

return 0

/*====================================================== */
/*=== Common Code - Delete unused, but do not modify === */
/*====================================================== */

/*=== Error() - report ERROR, FAILURE etc. conditions ===*/

Error:
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source = ' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Error */

/*=== Fatal(message) Report fatal error and exit ===*/

Fatal:
  parse arg szMsg
  say szMsg
  call LogWrite szMsg
  exit x2d(1604)		/* Unexpected condition */

/* end Fatal */

/*=== Halt() - report HALT condition ===*/

Halt:
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source = ' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Halt */

/*=== LogWrite(szLine): Write line to log ===*/

LogWrite: procedure expose Gbl.

  parse arg sz

  sz = date() time() Gbl.szCmdName':' sz
  if symbol('Gbl.szLogFile') == 'LIT' then
    say sz
  else do
    call lineout Gbl.szLogFile, date() time()':' sz
    if RESULT \= 0 then do
      say sz
      say 'Can not write to' Gbl.szLogFile
      exit x2d(1604)
    end
  end

  return

/* end LogWrite */

/* The end */
