/* MyCopy.Cmd: Simple copy

    Copyright (c) 2001 Steven Levine and Associates, Inc.
    All rights reserved.

    $TLIB$: $ &(#) %n - Ver %v, %f $
    TLIB: $ $

    Revisions	15 Oct 01 SHL - Release

*/

signal on ERROR
signal on FAILURE name Error
signal on HALT
signal on NOTREADY name Error
signal on NOVALUE name Error
signal on SYNTAX name Error

call Initialize

Main:

  parse arg szRest
  szRest = strip(szRest)

  do while szRest \= ''
    parse var szRest szArg szRest
    szRest = strip(szRest)
    szArgU = translate(szArg)

    select
    when left(szArgU, 3) == '/L:' then
      Gbl.szLogFile = substr(szArg, 4)
    when left(szArgU, 3) == '/S:' then
      Gbl.szImgSrc = substr(szArg, 4)
    when left(szArgU, 3) == '/T:' then
      Gbl.szTargetDir = substr(szArg, 4)
    otherwise
      call Usage szArg 'unexpected'
    end
  end /* while */

  if symbol('Gbl.szLogFile') = 'LIT' then
    call Usage '/L:  missing'

  if symbol('Gbl.szImgSrc') = 'LIT' then
    call Usage '/S:  missing'

  if symbol('Gbl.szTargetDir') = 'LIT' then
    call Usage '/T:  missing'

  call MakeDir Gbl.szTargetDir

  signal off error
  'copy' Gbl.szImgSrc Gbl.szTargetDir
  signal on error
  if RC \= 0 then
    call Fatal 'Copy' Gbl.szImgSrc Gbl.szTargetDir 'failed -' RC

  exit 0

/* end main */

/*=== Usage(szMsg): Report usage error ===*/

Usage:

  parse arg szMsg
  say szMsg
  call LogWrite szMsg
  say Gbl.szCmdName '/l:logfile /s:sourcedir /t:targetdir'
  call LogWrite Gbl.szCmdName '/l:logfile /s:sourcedir /t:targetdir'

  exit x2d(1600)		/* Incorrect invocation */

/* end UsageHelp */

/*====================================================== */
/*=== Common Code - Delete unused, but do not modify === */
/*====================================================== */

/*=== Error() - report ERROR, FAILURE etc. conditions ===*/

Error:
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source =' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Error */

/*=== Fatal(message) Report fatal error and exit ===*/

Fatal:
  parse arg szMsg
  say szMsg
  call LogWrite szMsg
  exit x2d(1604)		/* Unexpected condition */

/* end Fatal */

/*=== Halt() - report HALT condition ===*/

Halt:
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  say 'Source = ' sourceline(SIGL)
  say 'Exiting'
  exit x2d(1604)

/* end Halt */

/*=== Initialize: Intialize globals ===*/

Initialize:

  /* Set Gbl.szCmdName */

  parse source . . Gbl.szCmdName
  Gbl.szCmdName = filespec('N', Gbl.szCmdName)
  c = pos('.', Gbl.szCmdName)
  if c > 1 then
    Gbl.szCmdName = substr(Gbl.szCmdName, 1, c - 1)

  call LoadFuncs

  return

/* end Initialize */

/*=== LoadFuncs: Load fuctions ===*/

LoadFuncs:

/* Add all Rexx functions */
if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  if RESULT then
    call Fatal 'Cannot load SysLoadFuncs'
  call SysLoadFuncs
end /* end do */

return

/* end LoadFuncs */

/*=== LogWrite(szLine): Write line to log ===*/

LogWrite: procedure expose Gbl.

  parse arg sz

  sz = date() time() Gbl.szCmdName':' sz
  if symbol('Gbl.szLogFile') == 'LIT' then
    say sz
  else do
    call lineout Gbl.szLogFile, date() time()':' sz
    if RESULT \= 0 then do
      say sz
      say 'Can not write to' Gbl.szLogFile
      exit x2d(1604)
    end
  end

  return

/* end LogWrite */

/*=== MakeDir(szDirName): Make directory creating tree as needed ===*/

MakeDir: procedure expose Gbl.

  parse arg szTail
  szDir = ''

  do forever

    /* Build next */
    if szDir \= '' & right(szDir, 1) \= '\' then
      szDir = szDir'\'
    i = pos('\', szTail)
    if i = 0 then do
      szDir = szDir || szTail
      szTail = ''
    end
    else do
      szDir = szDir || substr(szTail, 1, i - 1)
      szTail = substr(szTail, i + 1)
    end

    if right(szDir, 2) = ':\' | right(szDir, 1) = ':' then do
      err = SysDriveInfo(left(szDir, 2))
      if err = '' then
        err = 3
      else
        err = 0
    end
    else do
      err = SysMkDir(szDir)
      if err = 5 then do
	call SysFileTree szDir, 'a', 'D'
        if RESULT = 0 then do
          if a.0 = 1 then
            err = 0                   /* Already exists */
        end
      end
    end
    if err \= 0 then
      call Fatal 'sysmkdir failed for' szDir '-' err
    if szTail == '' then
      leave
  end /* do */

  return err

/* end MakeDir */

/* The end */
