/* ClnW40Cfg.Cmd: Clean up Warp40 config

    Copyright (c) 2001 Steven Levine and Associates, Inc.
    All rights reserved.

    $TLIB$: $ &(#) %n - Ver %v, %f $
    TLIB: $ $

    Revisions	27 Feb 01 SHL - Release

*/

signal on ERROR
signal on FAILURE name Error
signal on HALT
signal on NOTREADY name Error
signal on NOVALUE name Error
signal on SYNTAX name Error

call Initialize

Main:

  parse arg bootDrv rest

  push 'DELLINE LANINSTEP'
  call 'x:\exe\v400\cube' QUEUE f:\config.sys'


  exit 0

/* end main */

/*=== LogOpen(void): Open log file ===*/

LogOpen: procedure expose Gbl. Log.

  call stream Log.!szFile, 'C', 'OPEN WRITE'

  if RESULT = '' then
    exit x2d(1604)

  return

/* end LogOpen */

/*=== LogWrite(szLine): Write line to log ===*/

LogWrite: procedure expose Log.

  parse arg sz

  call lineout Log.!szFile, date() time()' sladesk:' sz

  if RESULT \= 1 then
    exit x2d(1604)

  return

/* end LogWrite */

/*====================================================== */
/*=== Common Code - Delete unused, but do not modify === */
/*====================================================== */

/*=== CatchError: Catch condition for user ===*/

CatchError:

  szCondition = condition('C')
  return

/* end CatchError */

/*=== Error: Trap ERROR, FAILURE etc. conditions ===*/

Error:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source =' sourceline(SIGL)
  if condition('I') = 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
    say 'Exiting'
    exit x2d(1604)
  end

/* end Error */

/*=== Halt: Trap HALT condition ===*/

Halt:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source = ' sourceline(SIGL)
  if condition('I') = 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
   say 'Exiting'
   exit x2d(1604)
  end

/* end Halt */

/*=== Initialize: Intialize globals ===*/

Initialize:

call LoadFuncs

parse source . . szThisCmd

szTmpDir = value('TMP',,'OS2ENVIRONMENT')
if szTmpDir \= '' & right(szTmpDir, 1) \= ':' & right(szTmpDir, 1) \= '\' then
  szTmpDir = szTmpDir'\'

return

/* end Initialize */

/*=== LoadFuncs: Load fuctions ===*/

LoadFuncs:

/* Add all Rexx functions */
if RxFuncQuery('SysLoadFuncs') then do
  call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
  if RESULT then do
    say 'Cannot load SysLoadFuncs'
    exit
  end
  call SysLoadFuncs
end /* end do */

return

/* end LoadFuncs */

/* The end */
