:: init - init burn tools - slamain
::	  Define NOISOFS environment variable to suppress ISOFS daemon startup

:: Copyright (c) 2003, 2005 Steven Levine and Associates, Inc.
:: All rights reserved.

:: This program is free software licensed under the terms of the GNU
:: General Public License.  The GPL Software License can be found in
:: gnugpl2.txt or at http://www.gnu.org/licenses/licenses.html#GPL

rem $TLIB$: $ &(#) %n - Ver %v, %f $
rem TLIB: $ $

:: 01 Jun 03 SHL Baseline
:: 05 Jun 04 SHL Add isoc
:: 23 Jun 04 SHL Pass args to burn.  Add eject
:: 12 Jul 04 SHL Support NOISOFS
:: 05 Sep 04 SHL Move CD-RW from 1,4,0 to 0,4,0
:: 07 Sep 04 SHL Switch to cdrecord2 mkisofs2
:: 24 Jan 05 SHL Support both mkisfs and mkisofs2
:: 12 Apr 05 SHL isoc1 isoc2 pass args
:: 02 May 05 SHL Use 4os2 command sep
:: 20 Aug 05 SHL Try unixpaths
:: 04 Oct 05 SHL Switch to ISOFILE everywhere
:: 20 Oct 05 SHL Switch to ISOFS 1.0.1
:: 28 Nov 05 SHL Minor alias cleanup
:: 06 Dec 05 SHL Add speed alias

on errormsg pause

set DIR=J:\Util\BurnCDRom;D:\MMedia\CDRecord;D:\MMedia\ISOFS
set PATH=%DIR%;%PATH%
:: For help
set DIR=d:\MMedia\CDRecord

:: fixme to work
option //unixpaths=yes
set ISOFILE=j:/tmp/tmp.iso

:: Define CD-R
:: set CDR_DEVICE=1,4,0
set CDR_DEVICE=0,4,0
:: Not sure if tested - 4x worked as of 3/3/03
set CDR_SPEED=12
set CDR_FIFOSIZE=16M

:: Define tool aliases

:: Absolute time in pre-grove - media status
alias atip cdrecord2 -atip

:: Blank CD-RW
alias blank cdrecord2 -blank=fast

:: Record single-session using %ISOFILE
alias burns cdrecord2 -vv %%$ %%ISOFILE

:: Record multi-session using ISOFILE
alias burnm cdrecord2 -vv %%$ -multi %%ISOFILE

:: Record single-session using pipe
alias burnq `mkisofs2 -v -r -J %%$ -graft-points -path-list=pathlist.in -exclude-list=pathlist.out | cdrecord2 -vv -`

:: Avoid name conflict
if isalias cols unalias cols
alias c cdrecord2 %%$

:: daemon
alias dmn start isofsdmn.exe

:: Eject
alias ej*ect cdrecord2 -eject

:: Finalize
alias fix cdrecord2 -fix

:: Inquire
alias inq cdrecord2 -inq

:: Make iso image %ISOFILE using pathlist.in and pathlist.out
alias iso1 `mkisofs -v -o %ISOFILE -r -J -graft-points -path-list=pathlist.in -exclude-list=pathlist.out %+ dir "%ISOFILE"`
alias iso2 `mkisofs2 -v -o %ISOFILE -r -J -path-list=pathlist.in -exclude-list=pathlist.out %+ dir "%ISOFILE"`

:: Make iso image %ISOFILE using command line path specs
alias isoc1 `mkisofs -v -o %ISOFILE -r -J -graft-points %$ %+ dir "%ISOFILE"`
alias isoc2 `mkisofs2 -v -o %ISOFILE -r -J %$ %+ dir "%ISOFILE"`

:: Load
alias l*oad cdrecord2 -load

:: mount as Z:
alias mnt mapiso.exe z: %%ISOFILE

:: Scan bus
alias scan `cdrecord2 -scanbus | more`

:: Standard shutdown
alias shut `iff exist shut.cmd then %+ *shut %+ else %+ *..\shut %+ endiff`

:: Standard shutdown
alias speed `iff "%1" != "" then set CDR_SPEED=%1 %+ endiff %+ echo CDR_SPEED=%CDR_SPEED`

:: unmount Z:
alias umnt mapiso.exe -d z:

iff "%NOISOFS" != "" then
  @echo ISOFS daemon suppressed by %%NOISOFS.
else
  @echo Checking ISOFS daemon.
  pstat /c | grep -i isofsdmn >nul
  iff %? != 0 then
    @echo Starting daemon.
    start "ISOFS deamon" /b /c isofsdmn.exe
    delay 1
    pstat /c | grep -i isofsdmn
  endiff
endiff

history /a shut
history /a burns
history /a load
history /a eject
history /a blank
history /a umnt
history /a mnt
history /a iso2
history /a prep

title CDRecord
@echo.
@echo Use al to see alias commands
@echo ISOFILE is %ISOFILE

:: The end
