:: init - init for Bootable CD build
::	  workfiles at e:\tmp\0
::	  BootCD at e:\tmp\BootCD
::	  ISO at e:\tmp\BootISO\BootCD.iso

:: 07 Sep 04 SHL Switch to cdrecord2 mkisofs2
:: 24 Jan 05 SHL Support mkisfs mkisofs2
:: 20 Aug 05 SHL Use ISOFILE everywhere
:: 04 Oct 05 SHL Switch to ISOFILE everywhere
:: 11 Feb 06 SHL Drop excess iso* aliases to avoid finger faults

on errormsg pause

call winsize 120

set TMP=E:\TMP
set TMPU=%@replace[\,/,%TMP]

call ..\init.cmd

if not isdir e:\tmp\BootISO mkdir e:\tmp\BootISO
set ISOFILE=e:/tmp/BootISO/BootCD.iso

echo set PATH=d:\Util\Bootable;%=%PATH
@set PATH=d:\Util\Bootable;%PATH

:: Make bootable iso image %ISOFILE using boot image, pathlist.in and pathlist.out

set O=-r -J -no-emul-boot -b BOOTIMGS/cdloader.bin -path-list=pathlist.in -exclude-list=pathlist.out

:: -full-iso9660-filenames -iso-level 1

echo Clearing excess iso? aliases.
for %X in ( iso1 iso2 isoc1 isoc2 ) if isalias %X unalias %X

alias isob1 mkisofs -v -graft-points -o %=%ISOFILE %O %TMPU/BootCD `%+` dir "%=%ISOFILE"
alias isob2 mkisofs2 -v -o %=%ISOFILE %O %TMPU/BootCD `%+` dir "%=%ISOFILE"

:: Prepare OSBOOT.IMG and CD content
alias bldimg Bootable slamain.cfg BootCD.cfg

title BootCD

if not isdir %TMP\BootCD mkdir %TMP\BootCD

:: Descriptions off
setdos /d0

@echo Run prep.cmd to prepare utiities kit

@echo Ready to build bootable CDs
