/*  ReXX     */

/*  
PMGPEGgn.CMD
written by Dallas E. Legan
October 2002

A wrapper function for general use with text mode browsers
To launch image viewing programs

Usage: pmjpeggn  <temp_directory_variable>  <image_file>

Make sure /* ReXX  */  comment is on the first line,
starting in the first column!
   
--
   Where to use:
Lynx:                           used in 'lynx.cfg' file
                                examples:
XLOADIMAGE_COMMAND:pmjpeggn  LYNX_TEMP_SPACE %s  &
VIEWER:image/bmp:pmjpeggn  lynx_temp_space %s &:XWINDOWS
                               (for Unix type shell)
           or
XLOADIMAGE_COMMAND:start /c pmjpeggn  LYNX_TEMP_SPACE %s  
VIEWER:image/bmp:start /c pmjpeggn  lynx_temp_space %s :XWINDOWS
                               (for CMD.EXE shell)

      Also, you should define some none-null value
           for environmental variable 'DISPLAY'
           either in CONFIG.SYS or a wrapper function being
      used to launch Lynx.
      Under some circumstances, it may
      be used as the image viewer if it is
           set to the 'volume:/path/program' being used
      as the image viewer.
                
w3m:                            used in 'mailcap' file
                                example:
image/gif  ; cmd /c pmjpeggn   PWD  %s  ; ;
   
eLinks (and probably 'links'):  used in escape/setup/associations 
                                (Then escape/setup/save settings)
                                example, inside text based interface:
c:/os2/apps/pmjpegel  %
                                User will also need to define
                                extensions and types, 'www image'
                                'image/jpeg'  etc.
--
            
<temp_directory_variable>    might typically be:
            TMP
            TEMP
            TMPDIR
            LYNX_TEMP_SPACE
            PWD
--

<image_file>                 typically is '%s' (check browser documentation)
                             when the link to the image is activated
                             from the browser, the image is downloaded
                             to a local file for viewing, but there
                             seem to be some problems this script will
                             correct.
             
*/

/*  Grab the command line parameters, by various means:  */
PARSE       ARG   .     imagefile   ;
PARSE UPPER ARG   tdir  .  ;

/*
CALL  SysCls   ;

/*
   Lip service to loading the RexxUtils  until this is really needed.
   CALL LOADLIB.CMD
   IF RC = 1 THEN  SAY "Error: Couldn't load RexxUtil library."
   /*       FROM "ReXX COOKBOOK", P. 7-2, TO REGISTER ReXXUtil DLL    */
   */
   
*/

/*  extract  the name of the temporary/scratch directory
    typicly stored in the environmental variable whose
    name is stored in 'tdir', and was passed to this program
    on invocation:    */
wdir  =  Value( tdir, , 'OS2ENVIRONMENT' )  ;
IF  '' = wdir  THEN
   wdir  =  directory()  ;
/*           ---  for shells where environmental variable
                  PWD (for instance) might not be defined.
                  PWD ~ Present Working Directory
        pass PWD as a dummy variable if
        the browser uses the directory it was
        launched in for temporary files,
        instead of a directory identified by the value
        of an environmental variable.
                  This last IF statement will then
        grab the working directory to use.
        
*/

/*   convert   directory seperators to OS/2 standard:
     Major purpose of this script - Lynx likes and gives out '/'s
     but   OS/2  utilities frequently have to have '\'s
     as directory seperators.
*/
wdir  =  Translate( wdir, '\', '/' )  ;

/*  now move to the temporary/scratch directory:   */
wdirc  =  Directory( wdir )  ;


/*  make the same correction to the image file 
    directory, if it was part of the name passed
    to this script when invoked,
    standardizing the directory seperator.
 */
imagefile  =  Translate( imagefile, '\', '/' )  ;

/*  Now extract the file name extension, so the image format
    information can be saved:
 */
ofilename = imagefile  ;
/*
SAY 'ofilename ='ofilename'='  ;
*/
DO WHILE  '' >< ofilename
  PARSE VAR  ofilename   extension  '.' ofilename
END
/*   SAY 'extension ='extension'='  ;   */

newname  =  'elqqq.'extension  ;
/*  SAY 'newname ='newname'='  ;  */

/*  Note:   Possible future improvement:
            At this point it might be desirable to ask the user
            if they'd like to permenantly save a copy of the 
            image file, and take appropriate action.
       
       For this possible improvement, the VREXX package
       might be a good choice.
*/

/* move the image to another file name because 
   eLinks browser will immediately delete the
   file before pmjpeg.exe (or possibly other image
   viewers) get a chance to render the file.
   */
'@ECHO  off'   ;
'@del  'newname'  2> NUL  1>&2  '  ;
'@Copy  'imagefile'  'newname'  2> NUL 1>&2 '  ;

/*  Note:  Possible future improvement:
           At this point it might be appropriate to ask the user,
           with a menu of choices,
           what image viewer they would like to use,
       
      For this possible improvement also, 
      the VREXX package might be a good choice.
*/

/*    This is good for all but eLinks, which has a focus problem,
      where this flips back to eLinks instead of the image viewer:
   'start "Text mode browser  Viewer"  /F  /PM  /MAX  pmjpeg 'newname   ;
   
   
   (get 'go.exe' or a similar focus/task list tool from Hobbes.)
*/

'@start "Text mode browser  Viewer"  /F  /PM  /MAX  pmjpeg 'newname   ,
  ' &&   go -j pmjpeg   2> NUL 1>&2  '   ;


EXIT  ;

