/* */
/*
   Simple REXX script to connect to YAHOO's free
   delayed stock ticker and retrieve some values.

   The values are then feed into Mesa 2's real time
   feed table.
*/

/* Initial stocks to monitor. Separate with +      */
/* Setting to "" is fine.  As stocks are requested */
/* with the FEED function within Mesa, this script */
/* will automatically update this variable.        */
STOCKS = ""

/* Time (seconds) between refreshes */
REFRESHTIME = 10


/* server to connect to */
HOSTNAME = "quote.yahoo.com"
PORT = 80

/* Load the needed functions */
rc = RxFuncAdd("MesaLoadFeedFuncs","mesafeed","MesaLoadFeedFuncs")
call MesaLoadFeedFuncs
rc = RxFuncAdd("SysSleep","REXXUTIL","SysSleep")
rc = RxFuncAdd("SockLoadFuncs","rxSock","SockLoadFuncs")
rc = SockLoadFuncs()

/* Create the CRLF combo */
CRLF = D2C(13)""D2C(10)


/* Find the host address */
rc = SockGetHostByName(HOSTNAME,"thehost.!")
thehost.!port = PORT
thehost.!family = AF_INET

rc = SETFEED("YAHOO","STOP",0)

/* Initialize the list of stocks to monitor */
call INITIALIZESTOCKS

/* the loop */
do forever
   val = GETFEED("YAHOO","STOP");
   if val = 1 then do
      exit 0
   end
   call CHECKFORNEWSTOCKS
   if LENGTH(STOCKS) > 0 then do
       rc = DOQUOTES(STOCKS)
   end
   /* sleep */
   rc = SysSleep(REFRESHTIME)
end


/* Gets the quotes from YAHOO and sets them into the feed table */
DOQUOTES:
   quotes = ARG(1);

   /* HTML request */
   str = "GET /d/quotes.csv?f=sl1c1ohgv&e=.csv&s="quotes""CRLF;

   /* connect to the server */
   sckt = SockSocket(AF_INET, SOCK_STREAM, 0)
   rc = SockConnect(sckt,"thehost.!")
   /* send the command */
   rc = SockSend(sckt,str)
   /* get the buffer (20000 should be enough for a lot of stocks) */
   rc = SockRecv(sckt,"BUFFER",20000)

   do while LENGTH(BUFFER) > 10
      /* parse each line */
      parse var BUFFER with '"'stock'",'val","change","open","high","low","rest

      volume = LEFT(rest,POS(CRLF,rest))
      rest = RIGHT(rest,LENGTH(rest)-POS(CRLF,rest))

      if change = "N/A" then do
         return 1
      end
      
      say stock   val  change open high low volume
      
      /* set the feeds */
      rc = SetFeed("YAHOO",stock"/VALUE",val)
      rc = SetFeed("YAHOO",stock"/CHANGE",change)
      rc = SetFeed("YAHOO",stock"/OPEN",open)
      rc = SetFeed("YAHOO",stock"/HIGH",high)
      rc = SetFeed("YAHOO",stock"/LOW",low)
      rc = SetFeed("YAHOO",stock"/VOLUME",volume)
      BUFFER = rest
   end
   /* close the socket */
   rc = SockClose(sckt)
return 0


/* Checks the list of missing stock feeds for ones labled  */
/* with key1 as YAHOO.  For ones we find, we see if we can */
/* get valid data by calling DOQUOTES.  If so, we add it   */
/* to the list of stocks to monitor.                       */
CHECKFORNEWSTOCKS:
    numnew = GetMissingFeeds("STR1.","STR2.")
    if numnew > 0 then do
       do x = 1 to numnew by 1
          if STR1.x = "YAHOO" then do
             stck = LEFT(STR2.x,POS("/",STR2.x)-1)
             if POS(stck,STOCKS) = 0 then do
               /* new stock */
               if DOQUOTES(stck) = 0 then do
                  if \ (LENGTH(STOCKS) = 0) then do
                     STOCKS = STOCKS"+"
                  end
                  STOCKS = STOCKS""stck
               end
               else do 
                  rc = DELETEFEED("YAHOO",STR2.x)
               end
             end
          end
       end
    end
return 0


/* Initialize the stock list.  It does this by getting a list */
/* of all the feeds and checking for ones that are labeled as */
/* being from YAHOO.                                          */
INITIALIZESTOCKS:
    numnew = GetAllFeeds("STR1.","STR2.")
    if numnew > 0 then do
       do x = 1 to numnew by 1
          if STR1.x = "YAHOO" then do
             if \(STR2.x = "STOP") then do
                stck = LEFT(STR2.x,POS("/",STR2.x)-1)
                if POS(stck,STOCKS) = 0 then do
                  /* new stock */
                  if DOQUOTES(stck) = 0 then do
                     if \ (LENGTH(STOCKS) = 0) then STOCKS = STOCKS"+"
                     STOCKS = STOCKS""stck
                  end
                  else do 
                     rc = DELETEFEED("YAHOO",STR2.x)
                  end
                end
             end
          end
       end
    end
return 0
