/* Serenity25.Cmd: Connect to serenity systems port 25

    Copyright (c) 2001 Steven Levine and Associates, Inc.
    All rights reserved.

    $TLIB$: $ &(#) %n - Ver %v, %f $
    TLIB: $ $

    Revisions	14 Jun 01 SHL - Release

*/

signal on Error
signal on FAILURE name Error
signal on Halt
signal on NOTREADY name Error
signal on NOVALUE name Error
signal on SYNTAX name Error

call Initialize

Main:

  /* Load socket functions */
  rc = RxFuncAdd('SockLoadFuncs','rxSock','SockLoadFuncs')

  rc = SockLoadFuncs(0)

  parse arg sz

  /* Preset */
  Gbl.Version = '0.10';
  Gbl.HostName = 'mail.earthlink.net';
  Gbl.Port = 25                         /* service 25 = */

  call ScanArgs(sz)

  /* Do connect */

  rc = DoConnect()

  exit 0

/* end main */

/*=== DoConnect(): Send packet ===*/

DoConnect: procedure expose Gbl.

  achPkt = 'Hello'x2c('0d0a') 

  rc = SockGetHostByName(Gbl.HostName,'theHost.!')
  if rc \= 1 then
    call TCPFatal 'SockGetHostByName'

  say Gbl.HostName 'is' theHost.!addr

  sckt = SockSocket('AF_INET', 'SOCK_STREAM', 'IPPROTO_TCP')
  if sckt = -1 then
    call TCPFatal 'Socket'

  /* SockSetSockOpt is broken on object rexx so bypass if testing under OREXX */

  parse version szRexxVer .

  if szRexxVer == 'OBJREXX' then
    say 'Running OREXX.  Bypassing SockSetSockOpt'
  else do
    /* setsockopt(S, SOL_SOCKET, SO_BROADCAST, 1) or die "setsockopt :$!"; */
    rc = SockSetSockOpt(sckt, 'SOL_SOCKET', 'SO_BROADCAST', 1)
    if rc = -1 then
      call TCPFatal 'SockSetSockOpt'
  end

  say 'Connecting'

  theHost.!family = 'AF_INET'
  theHost.!port = Gbl.Port

  rc = SockConnect(sckt, 'theHost.!')
  if rc = -1 then
    call TCPFatal 'SockConnect'

  say 'Receiving'

  rc = SockRecv(sckt, 'achRsp', 512)
  if rc = -1 then
    call TCPFatal 'SockRecv'

  say 'rc' rc
  say 'Received' achRsp

  say 'Sending packet'

  rc = SockSend(sckt, achPkt)
  if rc = -1 then
    call TCPFatal 'SockSend'

  say 'Closing'

  rc = SockClose(sckt)
  if rc = -1 then
    call TCPFatal 'SockClose'

  return 0

/* end DoConnect */

/*=== Initialize: Intialize globals ===*/

Initialize:

  call LoadFuncs

  /* Set:
      Gbl.szCmdName

      Gbl.Opt.fDebug - default = 0
  */

  parse source . . Gbl.szCmdName
  Gbl.szCmdName = filespec('N', Gbl.szCmdName)
  c = pos('.', Gbl.szCmdName)
  if c > 1 then
    Gbl.szCmdName = ToLower(substr(Gbl.szCmdName, 1, c - 1))

  Gbl.Opt.fDebug = 0

  return

/* end Initialize */

/*=== ScanArgs(argLine): scan command line arguments and switches ===*/

ScanArgs: procedure expose Gbl.

  /* Evaluate arguments - override
     Return Gbl.Opt. and aArgs.
     fixme to do quotes
     Uses work stem Z
  */

  parse arg szRest
  szRest = strip(szRest)

  szSwCtl = 'fip'                       /* Switches that take args */
  szArg = ''
  szSw = ''
  fSwEnd = 0                            /* End of switches */

  do while szRest \== '' | szArg \== '' | szSw \== ''

    /* If arg buffer empty, refill */
    if szArg == '' then
      parse var szRest szArg szRest

    /* If switch buffer empty, refill */
    if szSw == '' then do
      if left(szArg, 1) == '-' then do
        if fSwEnd then
          call Usage 'switch '''szArg''' unexpected'
        else if szArg == '--' then
          fSwEnd = 1
        else
          szSw = substr(szArg, 2)
        parse var szRest szArg szRest
      end
    end

    /* If switch in progress */
    if szSw \== '' then do
      sz = left(szSw, 1)                /* Next switch */
      szSw = substr(szSw, 2)            /* Drop from pending */
      /* Check switch requires argument */
      if pos(sz, szSwCtl) \= 0 then do
        if szSw \== ''  then do
          szOpt = szSw
          szSw = ''
        end
        else if szArg \== '' & left(szArg, 1) \= '-' then do
          szOpt = szArg
          parse var szRest szArg szRest
        end
        else
          call Usage 'Switch' sz 'requires argument'
      end
      select
      when sz == '?' then
        signal UsageHelp
      when sz == 'd' then
        Gbl.Opt.fDebug = 1
      when sz == 'f' then
        Gbl.FileName = szOpt
      when sz == 'h' then
        signal UsageHelp
      when sz == 'i' then
        Gbl.HostName = szOpt
      when sz == 'p' then
        Gbl.Port = szOpt
      when sz == 'p' then
        Gbl.Port = szOpt
      when sz == 'v' then do
        say 'Serentity25' Gbl.Version
        exit
      end
      otherwise
        call Usage 'switch '''sz''' unexpected'
      end /* select */
    end /* if switch */

    /* If arg */
    else if szArg \== '' then do
      fSwEnd = 1                        /* No more switches */
      /* Got non switch arg */
      szArg = ''
    end

  end /* while szRest */

  return

/* end ScanArgs */

/*=== TCPFatal(szReq): Report TCPFatal Error... ===*/

TCPFatal:

  parse arg szReq

  call Fatal szReq 'failed, errno:' errno ', h_errno:' h_errno
  say 'Ooops'

  if sckt \= -1 then do
    say 'Closing socket' sckt
    call SockClose sckt
  end

  exit 253

/* end TCPFatal */

/*=== Usage(szMsg): Report Usage Error... ===*/

Usage:

  parse arg szMsg

  say szMsg
  say 'Usage:' Gbl.szCmdName 'hvp:i:f:'

  exit 255

/* end Usage */

/*=== Usage: Display help ===*/

UsageHelp:

  say
  say 'Usage:' Gbl.szCmdName 'hvp:i:f:'
  say
  say ' -h       This message'
  say ' -i IP    IP address (ddd.ddd.ddd.ddd, default 255.255.255.255)'
  say ' -p Port  Port address, default = 9'
  say ' -f File  File of hardware addresses xx:xx:xx:xx:xx:xx - no implemented'
  say ' -v       Report version'

  exit 255

/* end UsageHelp */

/*========================================================================== */
/*=== Standard functions - Delete unused.  Move modified above this mark === */
/*========================================================================== */

/*=== Error: Trap ERROR, FAILURE etc. conditions ===*/

Error:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source =' sourceline(SIGL)
  call SysSleep 2
  if condition('I') == 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
    trace '?A'
    say 'Exiting'
    call SysSleep 2
    exit 255
  end

/* end Error */

/*=== Fatal: Report fatal error and exit ===*/

Fatal:

  parse arg szMsg

  say
  say Gbl.szCmdName':' szMsg

  exit 254

/* end Fatal */

/*=== Halt: Trap HALT condition ===*/

Halt:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source = ' sourceline(SIGL)
  call SysSleep 2
  if condition('I') == 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
   say 'Exiting'
   exit
  end

/* end Halt */

/*=== LoadFuncs: Load fuctions ===*/

LoadFuncs:

  /* Add all Rexx functions */
  if RxFuncQuery('SysLoadFuncs') then do
    call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
    if RESULT then do
      say 'Cannot load SysLoadFuncs'
      exit
    end
    call SysLoadFuncs
  end /* end do */

  return

/* end LoadFuncs */

/*=== ToLower(sz): Convert to lower case ===*/

ToLower: procedure

  parse arg sz

  return translate(sz, xrange('a', 'z'), xrange('A', 'Z'))

/* end ToLower */

/* The end */
