/*
	MR/2 ICE - MSGUTIL.CMD

	Copyright (c) 1996, Nick Knight
	All Rights Reserved.

	Author: 	Nick Knight
	Created:	03/03/96
	Usage:		msgutil subcommand MessageFile
	Purpose:	msgutil.cmd allows for special processing of message
				files.	It is called from within MR/2 ICE, passed a
				subcommand based on the Fkey used to invoke it (F1 == 1,
				F12 = 12) and the current message file name.
	US Mail:	Nick Knight, PO Box 22366, Beachwood, Ohio 44122
    Internet:   nick@mr2ice.com

** Major Update: 04/16/96, gutted/rewritten using wonderful examples by:
   
   Author.........:  Jason Gottschalk, Internet: os2@tir.com
   Date Written...:  March 15, 1996

*/
/*
$MENUMAP
	1:Detach files using external utilities
	2:Edit the file with E.EXE
	3:View embedded HTML via Web Browser
$END
*/

/* USER SELECTABLE OPTIONS */

/* if set to 0, Ctrl-F1 will NOT attempt to load viewer */
EnableMimeViewers = 1	   

Editor = 'e'
Browser = 'H:\Mozilla\mozilla.exe'
BitmapViewer = 'ib.exe'
AviViewer = 'vb.exe'
WavPlayer = 'ab.exe'
INFViewer = 'view.exe'
MPGViewer = 'pmmpeg.exe'

html_file = 'mail.htm'

fNT = 1
'ver >ver$.tmp'
iline = linein('ver$.tmp')||linein('ver$.tmp')
if pos('/2',iline) > 0 then
	fNT = 0
rc = stream('ver$.tmp','c','close')
'del ver$.tmp >nul'

if fNT > 0 then
	env = 'ENVIRONMENT'    /* Access environment init variables */
else env = 'OS2ENVIRONMENT'    /* Access environment init variables */


/**********************************************************************/
/**   Parameter Section - Message Information Passed from MR/2 ICE	 **/
/**********************************************************************/
/* The section below is COMMENTED OUT to save resources.  If you	  */
/* wish to use one or more of these variables, just uncomment them	  */
/**********************************************************************/
/*

Subject 	= value("MR2I.SUBJECT",,env)
ReplyTo 	= value("MR2I.REPLYTO",,env)
To			= value("MR2I.TO",,env)
From		= value("MR2I.FROM",,env)
MessageID	= value("MR2I.MESSAGE-ID",,env)
InReplyTo	= value("MR2I.IN-REPLY-TO",,env)
Editor		= value("MR2I.EDITOR",,env)
SerialNumber= value("MR2I.SERIALNUMBER",,env)
Line		= value("MR2I.CURRENTLINE",,env)
Column		= value("MR2I.CURRENTCOLUMN",,env)

Browser 	= value("MR2I.BROWSER",,env)
FTPClient	= value("MR2I.FTPCLIENT",,env)
CurrentWord = value("MR2I.CURRENTWORD",,env)
Account 	= value("MR2I.ACCOUNT",,env)
Version 	= value("MR2I.VERSION",,env)

MarkedBlock = value("MR2I.CURRENTBLOCK",,env)
*/

/*
   NOTE that if markedBlock = "@rexx$txt.tmp", then the block was
   too big to pass in the environment, and it was instead saved to
   the file "rexx@txt.tmp".
*/	 

/**********************************************************************/


Signal on Syntax		/* Setup event handlers */
Signal on Halt
Signal on Novalue
					   
					   /* Include OS/2 Rexx utilities */

if RxFuncQuery('SysLoadFuncs') then
   do
	  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	  call SysLoadFuncs
   end


						   /* Run through some standard setup */

'@echo off'               /* turn off display of OS/2 commands */
crlf='0d0a'x              /* Set Carriage Return with LineFeed */


parse value SysCurPos() with row col   /* Get current cursor position */

CMDLineArgs = translate(arg(1)) 	   /* Snag everything from the command line */

esc  = '1b'x    /* ESC character */
P = esc'[35m'   /* ANSI.SYS-control for purple foreground */
r = esc'[31m'   /* ANSI.SYS-control for red foreground */
g = esc'[32m'   /* ANSI.SYS-control for green foreground */
y = esc'[33m'   /* ANSI.SYS-control for yellow foreground */
cy = esc'[36m'  /* ANSI.SYS-control for cyan foreground */
wh = esc'[0m'   /* ANSI.SYS-control for resetting attributes to normal */
bl = esc'[5m'   /* ANSI.SYS-control for blinking */
hl = esc'[1m'   /* ANSI.SYS-control for highlight */


FKey = 0

parse value CMDLineArgs with FKey filename
msg_filename = filename

select
  when FKey = 1 then
  do
   'mkdir attached 2>nul'
   'cd attached'
   'munpack 'filename
   'xbin 'filename
	if (EnableMimeViewers = 1) then
	  do while Lines(Filename) > 0
		InRec = LineIn(Filename)
		If pos('FILENAME="',translate(InRec)) > 0 then
		  do
			do while left(translate(InRec),10) <> 'FILENAME="'
			   InRec = strip(InRec,'L',left(InRec,1))
			end
			parse value InRec with file '"' DFile '"'
			DFile = translate(DFile)
			parse value DFile with Name '.' Ext
			if ext = 'TXT' | ext = 'DOC' | ext = 'ME' then
				'start 'Editor' 'dfile
			if ext = 'GIF' | ext = 'JPG' | ext = 'BMP' | ext = 'TIF' then
				'start 'BitmapViewer' 'dfile
			if ext = 'MPG' then 'start 'MPGViewer' 'dfile
			if ext = 'AVI' then 'start 'AviViewer' 'dfile
			if ext = 'WAV' then 'start 'WavPlayer' 'dfile
			if ext = 'INF' then 'start 'INFViewer' 'dfile
			'cd..'
			'exit'
		  end
		end
	   'cd ..'
  end
  
  when FKey = 2 then
  do
	'start 'Editor' 'filename
  end

  when FKey = 3 then
  do

	szTmpDir = value('TMP',,env)
	if Length(szTmpDir) < 1 then
		szTmpDir = "c:\"            /* force a full path, C:\ by default */
	else if right(szTmpDir, 1) \= '\' then
		szTmpDir = szTmpDir'\'
	html_file = szTmpDir||html_file

	rc = SysFileDelete(html_file)

	fHeader = 1
	do while lines(msg_filename) > 0 
		iline = linein(msg_filename)
		if length(iline) <= 1 then		/* cr's count as chars */
			fHeader = 0
		else if fHeader = 0 then
			rc = lineout(html_file,iline)
	end
	rc = stream(msg_filename,'c','close')
	rc = stream(html_file,'c','close')
	
	'start' Browser 'file:///'html_file

  end
  
  when FKey = 4 then
  do
	nop
  end
  
  when FKey = 5 then
  do
	nop
  end
  when FKey = 6 then
  do
	nop
  end
  when FKey = 7 then
  do
	nop
  end
  when FKey = 8 then
  do
	nop
  end
  when FKey = 10 then
  do
	nop
  end
  when FKey = 11 then
  do
	nop
  end
  when FKey = 12 then
  do
	nop
  end

  otherwise
	say 'Invalid Function Key passed by MR/2: 'FKey
end

exit
Syntax:
   Say 'A SYNTAX condition was raised on line' sigl'!'
   Say '  The error number is' rc', which means "'Errortext(rc)'"'
   problem_line = sigl
   Signal Abnormal_End

Halt:
   Say 'A Halt condition was raised on line' sigl'!'
   problem_line = sigl
   Signal Abnormal_End

Novalue:
   Say 'Novalue Condition raised on line' sigl'!'
   Say '  The variable which caused it is' Condition('Description')
   problem_line = sigl
   Signal Abnormal_End

Abnormal_End:
   Say '  That line is "'Sourceline(problem_line)'"'
   Say '  You can now debug if you want to.'
   Trace ?R
   Nop

Exit

