@echo off
rem SimTownTrc Setup for Simtown memory access trace

:: Copyright (c) 2002 Steven Levine and Associates, Inc.
:: All rights reserved.

rem $TLIB$: $ &(#) %n - Ver %v, %f $
rem TLIB: $ $

:: Revisions	24 Feb 02 SHL - Release

:: Define globals

set BOOTDRV=c:
set TRCEXE=SIMTOWN.EXE
set TRCEXEPATH=C:\MAXIS\SIMTOWN\SIMTOWN.EXE

setlocal

:: Establish trace buffer, as needed, err = 1055 if no buffer
trace /q
if not errorlevel 1 goto gotbuf
if not errorlevel 1054 pause
if errorlevel 1056 pause
  trace on /b:512
:gotbuf
@echo off

:: Need to run from boot drive for trace on kernel, so run from trace dir
%BOOTDRV%
cd \os2\system\trace

echo on

:: Include thread id in trace data
trace on /d:slot

:: Clear previous setups
trace off

:: Set up trace and clear buffer
:: Note trace codes are decimal

:: memory allocation
trace on os2krnlr(6,7,8,9,13,14,15,16,17,18,19,163,164,165,166,170,171,172,173,174,175,176)

trace on /N:%TRCEXEPATH%
@if errorlevel 1 pause

@echo.
trace /q

@echo off

@echo.
echo Use TraceCtl to monitor

:end

quit

00001 (0X0001) (OS) DosEnterCritSec Post-Invocation
00002 (0X0002) (OS) DosExitCritSec Post-Invocation
00003 (0X0003) (OS) DosHoldSignal Post-Invocation (2)
00006 (0X0006) (OS) Dos32AliasMem Post-Invocation
00007 (0X0007) (OS) Dos32AllocMem Post-Invocation
00008 (0X0008) (OS) Dos32AllocProtectedMem Post-Invocation
00009 (0X0009) (OS) Dos32AllocSharedMem Post-Invocation
00010 (0X000A) (OS) Dos32CreateThread Post-Invocation
00011 (0X000B) (OS) Dos32Debug Dos Post-Invocation
00012 (0X000C) (OS) Dos32ExitList Dos Post-Invocation
00013 (0X000D) (OS) Dos32FreeMem Post-Invocation
00014 (0X000E) (OS) Dos32GetNamedSharedMem Post-Invocation
00015 (0X000F) (OS) Dos32GetSharedMem Post-Invocation
00016 (0X0010) (OS) Dos32GiveSharedMem Post-Invocation
00017 (0X0011) (OS) Dos32QueryMem Post-Invocation
00018 (0X0012) (OS) Dos32QueryMemState Post-Invocation
00019 (0X0013) (OS) Dos32SetMem Post-Invocation
00020 (0X0014) (OS) DosAllocHuge Post-Invocation
00021 (0X0015) (OS) DosAllocProtHuge Post-Invocation
00022 (0X0016) (OS) DosAllocProtSeg Post-Invocation
00023 (0X0017) (OS) DosAllocSeg Post-Invocation
00024 (0X0018) (OS) DosAllocShrProtSeg Post-Invocation
00025 (0X0019) (OS) DosAllocShrSeg Post-Invocation
00026 (0X001A) (OS) DosBeep Post-Invocation
00027 (0X001B) (OS) DosBufReset Post-Invocation
00028 (0X001C) (OS) DosCallNmPipe Post-Invocation
00029 (0X001D) (OS) DosChDir Post-Invocation
00030 (0X001E) (OS) DosChgFilePtr Post-Invocation
00031 (0X001F) (OS) DosCliAccess Post-Invocation
00032 (0X0020) (OS) DosClose Post-Invocation
00033 (0X0021) (OS) DosCloseSem Post-Invocation
00034 (0X0022) (OS) DosConnectNmPipe Post-Invocation
00035 (0X0023) (OS) DosCreateCSAlias Post-Invocation
00036 (0X0024) (OS) DosCreateSem Post-Invocation
00037 (0X0025) (OS) DosCreateThread Post-Invocation
00038 (0X0026) (OS) DosCWait Post-Invocation
00039 (0X0027) (OS) DosDelete Post-Invocation
00040 (0X0028) (OS) DosDevConfig Post-Invocation
00041 (0X0029) (OS) DosDevIoctl2 Post-Invocation
00042 (0X002A) (OS) DosDevIoctl Post-Invocation
00043 (0X002B) (OS) DosDisConnectMmPipe Post-Invocation
00044 (0X002C) (OS) DosDupHandle Post-Invocation
00045 (0X002D) (OS) DosEditName Post-Invocation
00047 (0X002F) (OS) DosError Pre-Invocation
00049 (0X0031) (OS) Dos32Exit Dos Post-Invocation
00051 (0X0033) (OS) Dos32ExitList Dos Post-Invocation
00052 (0X0034) (OS) DosFileIO Post-Invocation
00053 (0X0035) (OS) DosFileLocks Post-Invocation
00054 (0X0036) (OS) DosFindClose Post-Invocation
00055 (0X0037) (OS) DosFindFirst2 Post-Invocation
00056 (0X0038) (OS) DosFindFirst Post-Invocation
00057 (0X0039) (OS) DosFindFromName Post-Invocation
00058 (0X003A) (OS) DosFindNext Post-Invocation
00059 (0X003B) (OS) DosFindNotifyClose Post-Invocation
00060 (0X003C) (OS) DosFindNotifyFirst Post-Invocation
00061 (0X003D) (OS) DosFindNotifyNext Post-Invocation
00062 (0X003E) (OS) DosFlagProcess Post-Invocation
00063 (0X003F) (OS) DosFreeModule Post-Invocation
00064 (0X0040) (OS) DosFreeSeg Post-Invocation
00065 (0X0041) (OS) DosFSAttach Post-Invocation
00066 (0X0042) (OS) DosFSCtl Post-Invocation
00067 (0X0043) (OS) DosGetDateTime Post-Invocation
00068 (0X0044) (OS) DosGetModHandle Post-Invocation
00069 (0X0045) (OS) DosGetModName Post-Invocation
00070 (0X0046) (OS) DosGetPid Post-Invocation
00071 (0X0047) (OS) DosGetProcAddr Post-Invocation
00072 (0X0048) (OS) DosGetPrty Post-Invocation
00073 (0X0049) (OS) DosGetResource Post-Invocation
00074 (0X004A) (OS) DosGetSeg Post-Invocation
00075 (0X004B) (OS) DosGetShrSeg Post-Invocation
00076 (0X004C) (OS) DosGetVersion Post-Invocation
00077 (0X004D) (OS) DosGiveSeg Post-Invocation
00078 (0X004E) (OS) DosHoldSignal Post-Invocation
00079 (0X004F) (OS) DosICopy Post-Invocation
00080 (0X0050) (OS) DosIExecPgm Post-Invocation
00083 (0X0053) (OS) DosISetCP Post-Invocation
00084 (0X0054) (OS) DosKillProcess Post-Invocation
00085 (0X0055) (OS) DosLoadModule Post-Invocation
00086 (0X0056) (OS) DosMakeNmPipe Post-Invocation
00087 ( 0X0057) (OS) DosMakePipe Post-Invocation
00088 (0X0058) (OS) DosMkDir2 Post-Invocation
00089 (0X0059) (OS) DosMkDir Post-Invocation
00095 (0X005F) (OS) DosMove Post-Invocation
00096 (0X0060) (OS) DosMuxSemWait Post-Invocation (Waited)
00097 (0X0061) (OS) DosNewSize Post-Invocation
00098 (0X0062) (OS) DosOpen2 Post-Invocation
00099 (0X0063) (OS) DosOpen Post-Invocation
00100 (0X0064) (OS) DosOpenSem Post-Invocation
00101 (0X0065) (OS) DosOpLockRelease Post-Invocation
00102 (0X0066) (OS) DosOpLockWait Post-Invocation
00103 (0X0067) (OS) DosPeekNmPipe Post-Invocation
00104 (0X0068) (OS) DosPhysicalDisk Post-Invocation
00105 (0X0069) (OS) DosQNmPipeState Post-Invocation
00106 (0X006A) (OS) DosPortAccess Post-Invocation
00108 (0X006C) (OS) DosQCurDir Post-Invocation
00109 (0X006D) (OS) DosQCurDisk Post-Invocation
00110 (0X006E) (OS) DosQFHandState Post-Invocation
00111 (0X006F) (OS) DosQFileInfo Post-Invocation
00112 (0X0070) (OS) DosQFileMode Post-Invocation
00113 (0X0071) (OS) DosQFSAttach Post-Invocation
00114 (0X0072) (OS) DosQFSInfo Post-Invocation
00115 (0X0073) (OS) DosQHandType Post-Invocation
00116 (0X0074) (OS) DosQNmPHandState Post-Invocation
00117 (0X0075) (OS) DosQNmPipeInfo Post-Invocation
00118 (0X0076) (OS) DosQPathInfo Post-Invocation
00119 (0X0077) (OS) DosQSysInfo Post-Invocation
00120 (0X0078) (OS) DosQVerify Post-Invocation
00121 (0X0079) (OS) DosRawReadNmPipe Post-Invocation
00122 (0X007A) (OS) DosRawWriteNmPipe Post-Invocation
00123 (0X007B) (OS) DosIRead Post-Invocation
00125 (0X007D) (OS) DosReallocHuge Post-Invocation
00126 (0X007E) (OS) DosReallocSeg Post-Invocation
00127 (0X007F) (OS) Dos32ResumeThread Dos Post-Invocation
00128 (0X0080) (OS) DosRmDir Post-Invocation
00129 (0X0081) (OS) DosSelectDisk Post-Invocation
00133 (0X0085) (OS) DosSemSetWait Post-Invocation
00135 (0X0087) (OS) DosSendSignal Post-Invocation
00137 (0X0089) (OS) DosSetDateTime Post-Invocation
00138 (0X008A) (OS) DosSetFHandState Post-Invocation
00139 (0X008B) (OS) DosSetFileInfo Post-Invocation
00140 (0X008C) (OS) DosSetFileMode Post-Invocation
00141 (0X008D) (OS) DosSetFSInfo Post-Invocation
00142 (0X008E) (OS) DosSetMaxFH Post-Invocation
00143 (0X008F) (OS) DosSetNmPHandState Post-Invocation
00144 (0X0090) (OS) DosSetNmPipeSem Post-Invocation
00145 (0X0091) (OS) DosSetPathInfo Post-Invocation
00146 (0X0092) (OS) DosSetPrty Post-Invocation
00147 (0X0093) (OS) DosSetSigHandler Post-Invocation
00148 (0X0094) (OS) DosSetVec Post-Invocation
00149 (0X0095) (OS) DosSetVerify Post-Invocation
00150 (0X0096) (OS) DosSleep Post-Invocation
00151 (0X0097) (OS) Dos32SuspendThread Dos Post-Invocation
00152 (0X0098) (OS) DosSystemService Post-Invocation
00153 (0X0099) (OS) DosTimerAsync Post-Invocation
00154 (0X009A) (OS) DosTimerStart Post-Invocation
00155 (0X009B) (OS) Dos32StopTimer Post-Invocation
00156 (0X009C) (OS) DosTransactNmPipe Post-Invocation
00157 (0X009D) (OS) DosWaitNmPipe Post-Invocation
00158 (0X009E) (OS) DosIWrite Post-Invocation
00163 (0X00A3) (OS) Dos32AliasMem Pre-Invocation
00164 (0X00A4) (OS) Dos32AllocMem Pre-Invocation
00165 (0X00A5) (OS) Dos32AllocProtectedMem Pre-Invocation
00166 (0X00A6) (OS) Dos32AllocSharedMem Pre-Invocation
00167 (0X00A7) (OS) Dos32CreateThread Pre-Invocation
00168 (0X00A8) (OS) Dos32Debug Dos Pre-Invocation
00169 (0X00A9) (OS) Dos32ExitList Dos Pre-Invocation
00170 (0X00AA) (OS) Dos32FreeMem Pre-Invocation
00171 (0X00AB) (OS) Dos32GetNamedSharedMem Pre-Invocation
00172 (0X00AC) (OS) Dos32GetSharedMem Pre-Invocation
00173 (0X00AD) (OS) Dos32GiveSharedMem Pre-Invocation
00174 (0X00AE) (OS) Dos32QueryMem Pre-Invocation
00175 (0X00AF) (OS) Dos32QueryMemState Pre-Invocation
00176 (0X00B0) (OS) Dos32SetMem Pre-Invocation
00177 (0X00B1) (OS) DosAllocHuge Pre-Invocation
00178 (0X00B2) (OS) DosAllocProtHuge Pre-Invocation
00179 (0X00B3) (OS) DosAllocProtSeg Pre-Invocation
00180 (0X00B4) (OS) DosAllocSeg Pre-Invocation
00181 (0X00B5) (OS) DosAllocShrProtSeg Pre-Invocation
00182 (0X00B6) (OS) DosAllocShrSeg Pre-Invocation
00183 (0X00B7) (OS) DosBeep Pre-Invocation
00184 (0X00B8) (OS) DosBufReset Pre-Invocation
00185 (0X00B9) (OS) DosCallNmPipe Pre-Invocation
00186 (0X00BA) (OS) DosChDir Pre-Invocation
00187 (0X00BB) (OS) DosChgFilePtr Pre-Invocation
00188 (0X00BC) (OS) DosCliAccess Pre-Invocation
00189 (0X00BD) (OS) DosClose Pre-Invocation
00190 (0X00BE) (OS) DosCloseSem Pre-Invocation
00191 (0X00BF) (OS) DosConnectNmPipe Pre-Invocation
00192 (0X00C0) (OS) DosCreateCSAlias Pre-Invocation
00193 (0X00C1) (OS) DosCreateSem Pre-Invocation
00194 (0X00C2) (OS) DosCreateThread Pre-Invocation
00195 (0X00C3) (OS) DosCWait Pre-Invocation
00196 (0X00C4) (OS) DosDelete Pre-Invocation
00197 (0X00C5) (OS) DosDevConfig Pre-Invocation
00198 (0X00C6) (OS) DosDevIoctl2 Pre-Invocation
00199 (0X00C7) (OS) DosDevIoctl Pre-Invocation
00200 (0X00C8) (OS) DosDisConnectMmPipe Pre-Invocation
00201 (0X00C9) (OS) DosDupHandle Pre-Invocation
00202 (0X00CA) (OS) DosEditName Pre-Invocation
00203 (0X00CB) (OS) DosEnterCritSec Pre-Invocation
00204 (0X00CC) (OS) DosError Pre-Invocation
00206 (0X00CE) (OS) DosExit Dos Pre-Invocation
00207 (0X00CF) (OS) DosExitCritSec Pre-Invocation
00208 (0X00D0) (OS) DosExitList Dos Pre-Invocation
00209 (0X00D1) (OS) DosFileIO Pre-Invocation
00210 (0X00D2) (OS) DosFileLocks Pre-Invocation
00211 (0X00D3) (OS) DosFindClose Pre-Invocation
00212 (0X00D4) (OS) DosFindFirst2 Pre-Invocation
00213 (0X00D5) (OS) DosFindFirst Pre-Invocation
00214 (0X00D6) (OS) DosFindFromName Pre-Invocation
00215 (0X00D7) (OS) DosFindNext Pre-Invocation
00216 (0X00D8) (OS) DosFindNotifyClose Pre-Invocation
00217 (0X00D9) (OS) DosFindNotifyFirst Pre-Invocation
00218 (0X00DA) (OS) DosFindNotifyNext Pre-Invocation
00219 (0X00DB) (OS) DosFlagProcess Pre-Invocation
00220 (0X00DC) (OS) DosFreeModule Pre-Invocation
00221 (0X00DD) (OS) DosFreeSeg Pre-Invocation
00222 (0X00DE) (OS) DosFSAttach Pre-Invocation
00223 (0X00DF) (OS) DosFSCtl Pre-Invocation
00224 (0X00E0) (OS) DosGetDateTime Pre-Invocation
00225 (0X00E1) (OS) DosGetModHandle Pre-Invocation
00226 (0X00E2) (OS) DosGetModName Pre-Invocation
00227 (0X00E3) (OS) DosGetPid Pre-Invocation
00228 (0X00E4) (OS) DosGetProcAddr Pre-Invocation
00229 (0X00E5) (OS) DosGetPrty Pre-Invocation
00230 (0X00E6) (OS) DosGetResource Pre-Invocation
00231 (0X00E7) (OS) DosGetSeg Pre-Invocation
00232 (0X00E8) (OS) DosGetShrSeg Pre-Invocation
00233 (0X00E9) (OS) DosGetVersion Pre-Invocation
00234 (0X00EA) (OS) DosGiveSeg Pre-Invocation
00235 (0X00EB) (OS) DosHoldSignal Pre-Invocation
00236 (0X00EC) (OS) DosICopy Pre-Invocation
00237 (0X00ED) (OS) DosIExecPgm Pre-Invocation
00240 (0X00F0) (OS) DosISetCP Pre-Invocation
00241 (0X00F1) (OS) DosKillProcess Pre-Invocation
00242 (0X00F2) (OS) DosLoadModule Pre-Invocation
00243 (0X00F3) (OS) DosMakeNmPipe Pre-Invocation
00244 (0X00F4) (OS) DosMakePipe Pre-Invocation
00245 (0X00F5) (OS) DosMkDir2 Pre-Invocation
00246 (0X00F6) (OS) DosMkDir Pre-Invocation
00252 (0X00FC) (OS) DosMove Pre-Invocation
00253 (0X00FD) (OS) DosMuxSemWait Pre-Invocation
00254 (0X00FE) (OS) DosNewSize Pre-Invocation
00255 (0X00FF) (OS) DosOpen2 Pre-Invocation
00256 (0X0100) (OS) DosOpen Pre-Invocation
00257 (0X0101) (OS) DosOpenSem Pre-Invocation
00258 (0X0102) (OS) DosOpLockRelease Pre-Invocation
00259 (0X0103) (OS) DosOpLockWait Pre-Invocation
00260 (0X0104) (OS) DosPeekNmPipe Pre-Invocation
00261 (0X0105) (OS) DosPhysicalDisk Pre-Invocation
00262 (0X0106) (OS) DosQNmPipeState Pre-Invocation
00263 (0X0107) (OS) DosPortAccess Pre-Invocation
00265 (0X0109) (OS) DosQCurDir Pre-Invocation
00266 (0X010A) (OS) DosQCurDisk Pre-Invocation
00267 (0X010B) (OS) DosQFHandState Pre-Invocation
00268 (0X010C) (OS) DosQFileInfo Pre-Invocation
00269 (0X010D) (OS) DosQFileMode Pre-Invocation
00270 ( 0X010E) (OS) DosQFSAttach Pre-Invocation
00271 (0X010F) (OS) DosQFSInfo Pre-Invocation
00272 (0X0110) (OS) DosQHandType Pre-Invocation
00273 (0X0111) (OS) DosQNmPHandState Pre-Invocation
00274 (0X0112) (OS) DosQNmPipeInfo Pre-Invocation
00275 (0X0113) (OS) DosQPathInfo Pre-Invocation
00276 (0X0114) (OS) DosQSysInfo Pre-Invocation
00277 (0X0115) (OS) DosQVerify Pre-Invocation
00278 (0X0116) (OS) DosRawReadNmPipe Pre-Invocation
00279 (0X0117) (OS) DosRawWriteNmPipe Pre-Invocation
00280 (0X0118) (OS) DosIRead Pre-Invocation
00282 (0X011A) (OS) DosReallocHuge Pre-Invocation
00283 (0X011B) (OS) DosReallocSeg Pre-Invocation
00284 (0X011C) (OS) DosResumeThread Dos Pre-Invocation
00285 (0X011D) (OS) DosRmDir Pre-Invocation
00286 (0X011E) (OS) DosSelectDisk Pre-Invocation
00290 (0X0122) (OS) DosSemSetWait Pre-Invocation
00292 (0X0124) (OS) DosSendSignal Pre-Invocation
00294 (0X0126) (OS) DosSetDateTime Pre-Invocation
00295 (0X0127) (OS) DosSetFHandState Pre-Invocation
00296 (0X0128) (OS) DosSetFileInfo Pre-Invocation
00297 (0X0129) (OS) DosSetFileMode Pre-Invocation
00298 (0X012A) (OS) DosSetFSInfo Pre-Invocation
00299 (0X012B) (OS) DosSetMaxFH Pre-Invocation
00300 (0X012C) (OS) DosSetNmPHandState Pre-Invocation
00301 (0X012D) (OS) DosSetNmPipeSem Pre-Invocation
00302 (0X012E) (OS) DosSetPathInfo Pre-Invocation
00303 (0X012F) (OS) DosSetPrty Pre-Invocation
00304 (0X0130) (OS) DosSetSigHandler Pre-Invocation
00305 (0X0131) (OS) DosSetVec Pre-Invocation
00306 (0X0132) (OS) DosSetVerify Pre-Invocation
00307 (0X0133) (OS) DosSleep Pre-Invocation
00308 (0X0134) (OS) DosSuspendThread Dos Pre-Invocation
00309 (0X0135) (OS) DosSystemService Pre-Invocation
00310 (0X0136) (OS) DosTimerAsync Pre-Invocation
00311 (0X0137) (OS) DosTimerStart Pre-Invocation
00312 (0X0138) (OS) Dos32StopTimer Pre-Invocation
00313 (0X0139) (OS) DosTransactNmPipe Pre-Invocation
00314 (0X013A) (OS) DosWaitNmPipe Pre-Invocation
00315 (0X013B) (OS) DosIWrite Pre-Invocation
00323 (0X0143) (OS) DosGetResource2 Pre-Invocation
00324 (0X0144) (OS) DosGetResource2 Post-Invocation
00325 (0X0145) (OS) DosFreeResource Pre-Invocation
00326 (0X0146) (OS) DosFreeResource Post-Invocation
00327 (0X0147) (OS) Dos32GetResource Pre-Invocation
00328 (0X0148) (OS) Dos32GetResource Post-Invocation
00331 (0X014B) (OS) Dos32FreeRsource Pre-Invocation
00332 (0X014C) (OS) Dos32FreeResource Post-Invocation
00333 (0X014D) (OS) Dos32QueryProcAddr Pre-Invocation
00334 (0X014E) (OS) Dos32QueryProcAddr Post-Invocation
00335 (0X014F) (OS) Dos32CreateEventSem Pre-Invocation
00336 (0X0150) (OS) Post-Invocation
00337 (0X0151) (OS) Dos32OpenEventSem Pre-Invocation
00338 (0X0152) (OS) Post-Invocation
00339 (0X0153) (OS) Dos32OpenEventSem Pre-Invocation
00340 (0X0154) (OS) Dos32CloseEventSem Post-Invocation
00341 (0X0155) (OS) Dos32ResetEventSem Pre-Invocation
00342 (0X0156) (OS) Dos32ResetEventSem Post-Invocation
00343 (0X0157) (OS) Dos32PostEventSem Pre-Invocation
00344 (0X0158) (OS) Dos32PostEventSem Post-Invocation
00345 (0X0159) (OS) Dos32WaitEvenSem Pre-Invocation
00346 (0X015A) (OS) Dos32WaitEventSem Post-Invocation
00347 (0X015B) (OS) Dos32QueryEventSem Pre-Invocation
00348 (0X015C) (OS) Dos32QueryEventSem Post-Invocation
00349 (0X015D) (OS) Dos32CreateMutexSem Pre-Invocation
00350 (0X015E) (OS) Dos32CreateMutexSem Post-Invocation
00351 (0X015F) (OS) Dos32OpenMutexSem Pre-Invocation
00352 (0X0160) (OS) Dos32OpenMutexSem Post-Invocation
00353 (0X0161) (OS) Dos32CloseMutexSem Pre-Invocation
00354 (0X0162) (OS) Dos32CloseMutexSem Post-Invocation
00355 (0X0163) (OS) Dos32RequestMutexSem Pre-Invocation
00356 (0X0164) (OS) Dos32RequestMutexSem Post-Invocation
00357 (0X0165) (OS) Dos32ReleaseMutexSem Pre-Invocation
00358 (0X0166) (OS) Dos32ReleaseMutexSem Post-Invocation
00359 (0X0167) (OS) Dos32QueryMutexSem Pre-Invocation
00360 (0X0168) (OS) Dos32QueryMutexSem Post-Invocation
00361 (0X0169) (OS) Dos32CreateMuxWaitSem Pre-Invocation
00362 (0X016A) (OS) Dos32CreateMuxWaitSem Post-Invocation
00363 (0X016B) (OS) Dos32OpenMuxWaitSem Pre-Invocation
00364 (0X016C) (OS) Dos32OpenMuxWaitSem Post-Invocation
00365 (0X016D) (OS) Dos32CloseMuxWaitSem Pre-Invocation
00366 (0X016E) (OS) Dos32CloseMuxWaitSem Post-Invocation
00367 (0X016F) (OS) Dos32WaitMuxWaitSem Pre-Invocation
00368 (0X0170) (OS) Dos32WaitMuxWaitSem Post-Invocation
00369 (0X0171) (OS) Dos32AddMuxWaitSem Pre-Invocation
00370 (0X0172) (OS) Dos32AddMuxWaitSem Post-Invocation
00371 ( 0X0173) (OS) Dos32DeleteMuxWaitSem Pre-Invocation
00372 (0X0174) (OS) Dos32DeleteMuxWaitSem Post-Invocation
00373 (0X0175) (OS) Dos32QueryMuxWaitSem Pre-Invocation
00374 (0X0176) (OS) Dos32QueryMuxWaitSem Post-Invocation
00375 (0X0177) (OS) DosGetCP Pre-Invocation
00376 (0X0178) (OS) DosGetCP Post-Invocation
00377 (0X0179) (OS) Dos32AsyncTimer Pre-Invocation
00378 (0X017A) (OS) Dos32AsyncTimer Post-Invocation
00379 (0X017B) (OS) Dos32StartTimer Pre-Invocation
00380 (0X017C) (OS) Dos32StartTimer Post-Invocation
00391 (0X0187) (OS) Dos32WaitThread Pre-Invocation
00392 (0X0188) (OS) Dos32WaitThread Post-Invocation
00393 (0X0189) (OS) Cluster Allocate Pre-Invocation
00394 (0X018A) (OS) Cluster Allocate Post-Invocation
00395 (0X018B) (OS) Cluster Release Pre-Invocation
00397 (0X018D) (OS) File Lock/Unlock Pre-Invocation
00401 (0X0191) (OS) Thread Reschedule Post-Invocation
00403 (0X0193) (OS) DosMuxSemWait Post-Invocation (No Wait)
00404 (0X0194) (OS) DosEnumAttribute Pre-Invocation
00405 (0X0195) (OS) DosEnumAttribute Post-Invocation
00406 (0X0196) (OS) DosISetFileInfo Pre-Invocation
00407 (0X0197) (OS) DosISetFileInfo Post-Invocation
00408 (0X0198) (OS) DosISetPathInfo Pre-Invocation
00409 (0X0199) (OS) DosISetPathInfo Post-Invocation
00410 (0X019A) (OS) Dos32QueryResource Pre-Invocation
00411 (0X019B) (OS) Dos32QueryResourceSize Post-Invocation
00412 (0X019C) (OS) DosIDevIoctl Pre-Invocation
00413 (0X019D) (OS) DosIDevIoctl Post-Invocation
00414 (0X019E) (OS) DosISetRelMaxFH Pre-Invocation
00415 (0X019F) (OS) DosISetRelMaxFH Post-Invocation
00416 (0X01A0) (OS) Dos32InitializePorthole Pre-Invocation
00417 (0X01A1) (OS) Dos32InitializePorthole Post-Invocation
00418 (0X01A2) (OS) Dos32QueryHeaderInfo Pre-Invocation
00419 (0X01A3) (OS) Dos32QueryHeaderInfo Post-Invocation
00420 (0X01A4) (OS) Dos32QueryProcType Pre-Invocation
00421 (0X01A5) (OS) Dos32QueryProcType Post-Invocation
00424 (0X01A8) (OS) DosOpen2Compt Pre-Invocation
00425 (0X01A9) (OS) DosOpen2Compt Post-Invocation
00428 (0X01AC) (OS) Dos32ISetFHState Pre-Invocation
00429 (0X01AD) (OS) Dos32ISetFHState Post-Invocation
00430 (0X01AE) (OS) Dos32IQUERYFHSTATE Pre-Invocation
00431 (0X01AF) (OS) Dos32IQUERYFHSTATE Post-Invocation
00432 (0X01B0) (OS) Dos32IRead Pre-Invocation
00433 (0X01B1) (OS) Dos32IRead Post-Invocation
00434 (0X01B2) (OS) Dos32IWrite Pre-Invocation
00435 (0X01B3) (OS) Dos32IWrite Post-Invocation
00436 (0X01B4) (OS) Dos32DumpProcess Pre-Invocation
00437 (0X01B5) (OS) Dos32DumpProcess Post-Invocation
00438 (0X01B6) (OS) Dos32SuppressPopUps Pre-Invocation
00439 (0X01B7) (OS) Dos32SuppressPopUps Post-Invocation
00440 (0X01B8) (OS) Dos32KillThread Pre-Invocation
00441 (0X01B9) (OS) Dos32KillThread Post-Invocation
00442 (0X01BA) (OS) Dos32IProtectSetFHState Pre-Invocation
00443 (0X01BB) (OS) Dos32IProtectSetFHState Post-Invocation
00444 (0X01BC) (OS) Dos32IPROTECTQUERYFHSTATE Pre-Invocation
00445 (0X01BD) (OS) Dos32IPROTECTQUERYFHSTATE Post-Invocation
00446 (0X01BE) (OS) DosProtectChgFilePtr Pre-Invocation
00447 (0X01BF) (OS) DosProtectChgFilePtr Post-Invocation
00448 (0X01C0) (OS) DosProtectClose Pre-Invocation
00449 (0X01C1) (OS) DosProtectClose Post-Invocation
00450 (0X01C2) (OS) DosCloseChangeNotify Pre-Invocation
00451 (0X01C3) (OS) DosCloseChangeNotify Post-Invocation
00452 (0X01C4) (OS) DosProtectEnumAttribute Pre-Invocation
00453 (0X01C5) (OS) DosProtectEnumAttribute Post-Invocation
00454 (0X01C6) (OS) DosProtectFileIO Pre-Invocation
00455 (0X01C7) (OS) DosProtectFileIO Post-Invocation
00456 (0X01C8) (OS) DosProtectFileLocks Pre-Invocation
00457 (0X01C9) (OS) DosProtectFileLocks Post-Invocation
00458 (0X01CA) (OS) DosForceDelete Pre-Invocation
00459 (0X01CB) (OS) DosForceDelete Post-Invocation
00460 (0X01CC) (OS) DosIProtectRead Pre-Invocation
00461 (0X01CD) (OS) DosIProtectRead Post-Invocation
00462 (0X01CE) (OS) DosIProtectSetFileInfo Pre-Invocation
00463 (0X01CF) (OS) DosIProtectSetFileInfo Post-Invocation
00464 (0X01D0) (OS) DosIPROTECTWrite Pre-Invocation
00465 (0X01D1) (OS) DosIProtectWrite Post-Invocation
00466 (0X01D2) (OS) DosProtectNewSize Pre-Invocation
00467 (0X01D3) (OS) DosProtectNewSize Post-Invocation
00468 (0X01D4) (OS) DOSPROTECTOPEN Pre-Invocation
00469 (0X01D5) (OS) DosProtectOpen Post-Invocation
00470 (0X01D6) (OS) DosOpenChangeNotify Pre-Invocation
00471 (0X01D7) (OS) DosOpenChangeNotify Post-Invocation
00472 (0X01D8) (OS) DosProtectQFHandState Pre-Invocation
00473 (0X01D9) (OS) DosProtectQFHandState Post-Invocation
00474 (0X01DA) (OS) DosProtectQFileInfo Pre-Invocation
00475 (0X01DB) (OS) DosProtectQFileInfo Post-Invocation
00476 (0X01DC) (OS) DosResetChangeNotify Pre-Invocation
00477 (0X01DD) (OS) DosResetChangeNotify Post-Invocation
00478 (0X01DE) (OS) DosProtectSetFHandState Pre-Invocation
00479 (0X01DF) (OS) DosProtectSetFHandState Post-Invocation
00480 (0X01E0) (OS) DosProtectSetFileInfo Pre-Invocation
00481 (0X01E1) (OS) DosProtectSetFileInfo Post-Invocation
00482 (0X01E2) (OS) Dos32PMPostEventSem Pre-Invocation
00483 (0X01E3) (OS) Dos32PMPostEventSem Post-Invocation
00484 (0X01E4) (OS) Dos32PMWaitEventSem Post-Invocation
00485 (0X01E5) (OS) Dos32WaitMuxWaitSem Pre-Invocation
00486 (0X01E6) (OS) Dos32PMWaitMuxWaitSem Post-Invocation
00487 (0X01E7) (OS) Dos32QueryExtLIBPATH Pre-Invocation
00488 (0X01E8) (OS) Dos32QueryExtLIBPATH Post-Invocation
00489 (0X01E9) (OS) Dos32SetExtLIBPATH Pre-Invocation
00490 (0X01EA) (OS) Dos32SetExtLIBPATH Post-Invocation
00491 (0X01EB) (OS) Dos32VERIFYPIDTID Pre-Invocation
00492 (0X01EC) (OS) Dos32VERIFYPIDTID Post-Invocation
00493 (0X01ED) (OS) Dos32PMWaitEvenSem Pre-Invocation
32768 (0X8000) (OS) DosSetTraceInfo Pre-Invocation
65521 (0XFFF1) (OS) DosSetTraceInfo Post-Invocation
