/***********************************************************************
 RealPlay.exe.cmd - Run RealPlayer using Odin PE
 Steven H. Levine

 Copyright (c) 2000 Steven Levine and Associates, Inc.
 All rights reserved.

 Use at your own risk.
 You may do anything with this file except sell it to others.

 Revisions:     05 Jul 00 SHL - Version 1.0

 Usage: RealPlay.exe.cmd PlayListFile

 PlayListFile: contains URL's to play, one per line
 CMD file name must contain 'RealPlay.exe' to suppress download dialog box

***********************************************************************/

signal on Error
signal on FAILURE name Error
signal on Halt
signal on NOTREADY name Error
signal on NOVALUE name Error
signal on SYNTAX name Error

Main:

/* Arg is file containing a list of URL's to play.  Passed by Netscape */
parse arg szPlayListFile

/* Load REXX functions. */
call LoadFuncs

/* USERDEF: Define paths, files and options */

RADir           = 'D:\Real\RealPlayer'
RAHist          = 1                     /* 1 = keep track of URL's */

OdinDir         = 'd:\Odin'             /* Odin install directory */
OdinInit        = 1                     /* 1 = Initialize Odin here
                                           0 = Odin initialized elsewhere */
OdinLog         = 1                     /* 1 = Enable Odin logging
                                           0 = Disable Odin logging */

/* Initialize */

RAPlayer        = RADir||'\realplay.exe'
RATempFile      = RADir||'\RealPlay7.tmp'
RALogFile       = RADir||'\RealPlay7.log'
RAHistFile      = RADir||'\RealPlay7.hst'             /* URL play history */

/* Check arguments */

if szPlayListFile == '' then do
  say 'Usage: RealPlay7 playlistfile'
  call lineout RALogFile, date() time() 'RealPlay7.cmd: no playlist specified'
  exit 1
end

/* Check play list file */

if stream(szPlayListFile, 'C', 'QUERY EXISTS') == '' then do
  say szPlayListFile 'can not be found'
  call lineout RALogFile, date() time() 'RealPlay7.cmd:' szPlayListFile 'can not be found'
  exit 1
end

/* Copy passed playlist file to a work file */

'@copy' szPlayListFile RATempFile

/* If URL logging requested, write history file */

if RAHist = 1 then do
  /* Avoid logging content of binary files */
  szRange = xrange('00'x, '1f'x) || xrange('80'x, 'ff'x)
  call on NOTREADY name CatchError      /* Avoid death on missing NL */
  do while lines(szPlayListFile) \= 0
    sz = linein(szPlayListFile)
    i = verify(sz, szRange, 'M')
    if i \= 0 then do
      call lineout RAHistFile, szPlayListFile
      leave                             /* Assume binary */
    end
    call lineout RAHistFile, sz
    call on NOTREADY name CatchError    /* Avoid death on missing NL */
  end
  call stream szPlayListFile, 'C', 'CLOSE'
  signal on NOTREADY name Error
  call stream RAHistFile, 'C', 'CLOSE'
end

/* Run the Real Player program from the desktop icon. */
/* Create an addressable desktop object ( if not already created ).*/

/* Try to open */

say 'Starting RealPlayer for' szPlayListFile

if OdinInit then do
  'SET WIN32LOG_ENABLED='OdinLog
  'SET PATH='OdinDir'\System32;%PATH%'
  'SET BEGINLIBPATH='OdinDir'\System32'
end

OldDir = directory()

call directory RADir

'pe' RAPlayer RATempFile

call directory OldDir

exit

/*========================================================================== */
/*=== Standard functions - Delete unused.  Move modified above this mark === */
/*========================================================================== */

/*=== CatchError: Catch condition for user ===*/

CatchError:

  szCondition = condition('C')
  return

/* end CatchError */

/*=== Error: Trap ERROR, FAILURE etc. conditions ===*/

Error:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source =' sourceline(SIGL)
  call SysSleep 2
  if condition('I') == 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
    trace '?A'
    say 'Exiting'
    call SysSleep 2
    exit 255
  end

/* end Error */

/*=== Halt: Trap HALT condition ===*/

Halt:

  /*=== Returns szCondition or Exits ===*/

  say
  parse source . . szThisCmd
  say condition('C') 'signaled at' SIGL 'of' szThisCmd
  drop szThisCmd
  say 'Source = ' sourceline(SIGL)
  call SysSleep 2
  if condition('I') == 'CALL' then do
    szCondition = condition('C')
    say 'Returning'
    return
  end
  else do
   say 'Exiting'
   exit
  end

/* end Halt */

/*=== LoadFuncs: Load fuctions ===*/

LoadFuncs:

  /* Add all Rexx functions */
  if RxFuncQuery('SysLoadFuncs') then do
    call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
    if RESULT then do
      say 'Cannot load SysLoadFuncs'
      exit
    end
    call SysLoadFuncs
  end /* end do */

  return

/* end LoadFuncs */

/* The end */
